<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up()
    {
        Schema::create('mpesa_credentials', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('business_id');
            $table->string('consumer_key');
            $table->string('consumer_secret');
            $table->string('shortcode');
            $table->string('passkey');
            $table->string('initiator_name')->nullable();
            $table->string('initiator_password')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('mpesa_credentials');
    }
};